#include <bits/stdc++.h>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>

using namespace __gnu_pbds;
using namespace std;

#define all(v) v.begin(), v.end()
#define rall(v) v.begin(), v.rend()

typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;

struct DSU {
    vector<int> p, r;

    DSU() {}
    DSU(int n) {
        p.resize(n);
        iota(all(p), 0);
        r.assign(n, 0);
    }

    int get(int a) {
        if (p[a] != a) {
            p[a] = get(p[a]);
        }
        return p[a];
    }

    bool unite(int a, int b) {
        a = get(a);
        b = get(b);
        if (a == b) return false;
        if (r[a] < r[b]) swap(a, b);
        p[b] = a;
        r[a] += r[a] == r[b];
        return true;
    }
};

struct Point {
    ll x, y;
};
bool operator<(Point a, Point b) {
    return tie(a.x, a.y) < tie(b.x, b.y);
}
bool operator==(Point a, Point b) {
    return tie(a.x, a.y) == tie(b.x, b.y);
}

ll dot(Point a, Point b) {
    return a.x * b.x + a.y * b.y;
}
ll cross(Point a, Point b) {
    return a.x * b.y - b.x * a.y;
}

ll sign(ll x) {
    if (x == 0) return 0;
    return x / abs(x);
}

bool check(pair<Point, Point> seg, Point C) {
    Point A = seg.first;
    Point B = seg.second;

    Point AC = {C.x - A.x, C.y - A.y};
    Point CB = {B.x - C.x, B.y - C.y};

    return dot(AC, CB) > 0 && cross(AC, CB) == 0;
}

bool check(pair<Point, Point> seg1, pair<Point, Point> seg2) {
    Point A = seg1.first;
    Point B = seg1.second;
    Point C = seg2.first;
    Point D = seg2.second;

    Point AB = {B.x - A.x, B.y - A.y};
    Point AC = {C.x - A.x, C.y - A.y};
    Point AD = {D.x - A.x, D.y - A.y};
    return sign(cross(AB, AC)) * sign(cross(AB, AD)) < 0;
}

bool intersect(pair<Point, Point> seg1, pair<Point, Point> seg2) {
    return check(seg1, seg2) && check(seg2, seg1);
}

void solve() {
    int n;
    cin >> n;
    DSU dsu(n);

    set<Point> vtx;

    ll v = 0;
    ll e = 0;
    vector<pair<Point, Point>> seg(n);
    for (int i = 0; i < n; i++) {
        cin >> seg[i].first.x >> seg[i].first.y >> seg[i].second.x >> seg[i].second.y;
        if (!vtx.count(seg[i].first)) {
            v++;
            vtx.insert(seg[i].first);
        }
        if (!vtx.count(seg[i].second)) {
            v++;
            vtx.insert(seg[i].second);
        }
        e++;

        for (int j = 0; j < i; j++) {
            if (seg[i].first == seg[j].first || seg[i].first == seg[j].second || seg[i].second == seg[j].first || seg[i].second == seg[j].second) {
                dsu.unite(i, j);
                continue;
            }

            if (check(seg[i], seg[j].first) || check(seg[i], seg[j].second) || check(seg[j], seg[i].first) || check(seg[j], seg[i].second)) {
                dsu.unite(i, j);
                e++;
                continue;
            }

            if (intersect(seg[i], seg[j])) {
                dsu.unite(i, j);
                e += 2;
                v++;
            }
        }
    }

    int comp = 0;
    for (int i = 0; i < n; i++) comp += i == dsu.get(i);

    cout << 2 - v + e + (comp - 1) << '\n';
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int tests;
    cin >> tests;
    while (tests--) {
        solve();
    }

    return 0;
}
